<!DOCTYPE html>
<html lang="en">

<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>SheerID Matrix Verifier</title>
    <style>
        body {
            background-color: #000;
            color: #00ff00;
            font-family: "Courier New", Courier, monospace;
            display: flex;
            flex-direction: column;
            align-items: center;
            justify-content: center;
            min-height: 100vh;
            margin: 0;
            overflow: hidden;
        }

        /* Matrix Rain Background Effect (CSS only approximation) */
        body::before {
            content: "";
            position: absolute;
            top: 0;
            left: 0;
            width: 100%;
            height: 100%;
            background: linear-gradient(rgba(18, 16, 16, 0) 50%, rgba(0, 0, 0, 0.25) 50%), linear-gradient(90deg, rgba(255, 0, 0, 0.06), rgba(0, 255, 0, 0.02), rgba(0, 0, 255, 0.06));
            background-size: 100% 2px, 3px 100%;
            pointer-events: none;
            z-index: -1;
        }

        .container {
            width: 80%;
            max-width: 800px;
            background: rgba(0, 20, 0, 0.9);
            border: 1px solid #00ff00;
            padding: 2rem;
            box-shadow: 0 0 20px rgba(0, 255, 0, 0.5);
            position: relative;
            z-index: 1;
        }

        h1 {
            text-align: center;
            text-transform: uppercase;
            letter-spacing: 5px;
            text-shadow: 0 0 10px #00ff00;
            margin-bottom: 2rem;
            animation: flicker 2s infinite;
        }

        @keyframes flicker {
            0% {
                opacity: 0.8;
            }

            5% {
                opacity: 1;
            }

            10% {
                opacity: 0.9;
            }

            15% {
                opacity: 0.2;
            }

            20% {
                opacity: 1;
            }

            100% {
                opacity: 1;
            }
        }

        .input-group {
            display: flex;
            gap: 10px;
            margin-bottom: 20px;
        }

        input[type="text"] {
            background: #000;
            border: 1px solid #00ff00;
            color: #00ff00;
            padding: 15px;
            width: 100%;
            font-family: inherit;
            font-size: 1.2rem;
            outline: none;
        }

        input[type="text"]::placeholder {
            color: rgba(0, 255, 0, 0.3);
        }

        button {
            background: #00ff00;
            color: #000;
            border: none;
            padding: 15px 30px;
            font-family: inherit;
            font-weight: bold;
            font-size: 1.2rem;
            cursor: pointer;
            transition: all 0.3s;
        }

        button:hover {
            background: #fff;
            box-shadow: 0 0 20px #00ff00;
        }

        button:disabled {
            background: #333;
            color: #555;
            cursor: not-allowed;
            box-shadow: none;
        }

        .terminal {
            background: #000;
            border: 1px solid #003300;
            height: 300px;
            overflow-y: auto;
            padding: 15px;
            margin-top: 20px;
            font-size: 0.9rem;
            box-shadow: inset 0 0 10px rgba(0, 255, 0, 0.2);
        }

        .terminal::-webkit-scrollbar {
            width: 8px;
        }

        .terminal::-webkit-scrollbar-thumb {
            background: #00ff00;
        }

        .terminal::-webkit-scrollbar-track {
            background: #001100;
        }

        .line {
            margin-bottom: 5px;
            opacity: 0;
            animation: type 0.1s forwards;
            white-space: pre-wrap;
        }

        @keyframes type {
            to {
                opacity: 1;
            }
        }

        .cursor {
            display: inline-block;
            width: 10px;
            height: 1.2em;
            background: #00ff00;
            animation: blink 1s step-end infinite;
            vertical-align: text-bottom;
        }

        @keyframes blink {
            50% {
                opacity: 0;
            }
        }
    </style>
</head>

<body>

    <div class="container">
        <h1>System Access</h1>

        <div class="input-group">
            <input type="text" id="urlInput" placeholder="ENTER VERIFICATION URL..." autofocus>
            <button id="verifyBtn" onclick="startVerification()">INITIATE</button>
        </div>

        <div class="terminal" id="terminal">
            <div class="line">Wait for input...</div>
            <span class="cursor"></span>
        </div>
    </div>

    <script>
        const terminal = document.getElementById('terminal');
        const urlInput = document.getElementById('urlInput');
        const verifyBtn = document.getElementById('verifyBtn');
        let eventSource = null;

        function log(message) {
            // Remove cursor temporarily
            const cursor = terminal.querySelector('.cursor');
            if (cursor) cursor.remove();

            const line = document.createElement('div');
            line.className = 'line';
            line.textContent = `> ${message}`;
            terminal.appendChild(line);

            // Add cursor back
            terminal.appendChild(cursor || createCursor());

            terminal.scrollTop = terminal.scrollHeight;
        }

        function createCursor() {
            const span = document.createElement('span');
            span.className = 'cursor';
            return span;
        }

        function startVerification() {
            const url = urlInput.value.trim();
            if (!url) {
                log("ERROR: URL PARAMETER MISSING");
                return;
            }

            // Reset UI
            verifyBtn.disabled = true;
            if (eventSource) eventSource.close();

            log(`CONNECTING TO HOST: ${url.substring(0, 30)}...`);

            // Start SSE
            eventSource = new EventSource(`stream.php?url=${encodeURIComponent(url)}`);

            eventSource.onmessage = function (event) {
                log(event.data);
            };

            eventSource.addEventListener('error', function (event) {
                // If readyState is closed, it might just be the end of stream or actual error
                if (eventSource.readyState === EventSource.CLOSED) {
                    log("CONNECTION TERMINATED");
                } else {
                    log("SYSTEM ERROR: CONNECTION LOST");
                }
                eventSource.close();
                verifyBtn.disabled = false;
            });

            eventSource.addEventListener('complete', function (event) {
                const data = JSON.parse(event.data);
                log("PROCESS COMPLETE.");
                log(`STATUS: ${data.success ? 'SUCCESS' : 'FAILURE'}`);
                if (data.redirect_url) {
                    log(`REDIRECTING...`);
                    setTimeout(() => window.open(data.redirect_url, '_blank'), 2000);
                }
                eventSource.close();
                verifyBtn.disabled = false;
            });
        }
    </script>
</body>

</html>