<?php

class NameGenerator
{
    private static $roots = [
        'prefixes' => [
            'Al',
            'Bri',
            'Car',
            'Dan',
            'El',
            'Fer',
            'Gar',
            'Har',
            'Jes',
            'Kar',
            'Lar',
            'Mar',
            'Nor',
            'Par',
            'Quin',
            'Ros',
            'Sar',
            'Tar',
            'Val',
            'Wil'
        ],
        'middles' => [
            'an',
            'en',
            'in',
            'on',
            'ar',
            'er',
            'or',
            'ur',
            'al',
            'el',
            'il',
            'ol',
            'am',
            'em',
            'im',
            'om',
            'ay',
            'ey',
            'oy',
            'ian'
        ],
        'suffixes' => [
            'ton',
            'son',
            'man',
            'ley',
            'field',
            'ford',
            'wood',
            'stone',
            'worth',
            'berg',
            'stein',
            'bach',
            'heim',
            'gard',
            'land',
            'wick',
            'shire',
            'dale',
            'brook',
            'ridge'
        ],
        'name_roots' => [
            'Alex',
            'Bern',
            'Crist',
            'Dav',
            'Edw',
            'Fred',
            'Greg',
            'Henr',
            'Ivan',
            'John',
            'Ken',
            'Leon',
            'Mich',
            'Nick',
            'Oliv',
            'Paul',
            'Rich',
            'Step',
            'Thom',
            'Will'
        ],
        'name_endings' => [
            'a',
            'e',
            'i',
            'o',
            'y',
            'ie',
            'ey',
            'an',
            'en',
            'in',
            'on',
            'er',
            'ar',
            'or',
            'el',
            'al',
            'iel',
            'ael',
            'ine',
            'lyn'
        ]
    ];

    private static $patterns = [
        'first_name' => [
            ['prefix', 'ending'],
            ['name_root', 'ending'],
            ['prefix', 'middle', 'ending'],
            ['name_root', 'middle', 'ending']
        ],
        'last_name' => [
            ['prefix', 'suffix'],
            ['name_root', 'suffix'],
            ['prefix', 'middle', 'suffix'],
            ['compound']
        ]
    ];

    private static function generateComponent($pattern)
    {
        $components = [];
        foreach ($pattern as $part) {
            if ($part == 'compound') {
                $part1 = self::$roots['prefixes'][array_rand(self::$roots['prefixes'])];
                $part2 = self::$roots['suffixes'][array_rand(self::$roots['suffixes'])];
                $component = $part1 . $part2;
            } else {
                $list = self::$roots[$part . (substr($part, -1) == 's' ? '' : 's')];
                // Handle singular/plural inconsistency if any (Python code mapped 'prefix' -> 'prefixes')
                if ($part == 'prefix')
                    $list = self::$roots['prefixes'];
                if ($part == 'middle')
                    $list = self::$roots['middles'];
                if ($part == 'suffix')
                    $list = self::$roots['suffixes'];
                if ($part == 'name_root')
                    $list = self::$roots['name_roots'];
                if ($part == 'ending')
                    $list = self::$roots['name_endings'];

                $component = $list[array_rand($list)];
            }
            $components[] = $component;
        }
        return implode('', $components);
    }

    private static function formatName($name)
    {
        return ucfirst(strtolower($name));
    }

    public static function generate()
    {
        $firstNamePattern = self::$patterns['first_name'][array_rand(self::$patterns['first_name'])];
        $lastNamePattern = self::$patterns['last_name'][array_rand(self::$patterns['last_name'])];

        $firstName = self::generateComponent($firstNamePattern);
        $lastName = self::generateComponent($lastNamePattern);

        $formattedFirst = self::formatName($firstName);
        $formattedLast = self::formatName($lastName);

        return [
            'first_name' => $formattedFirst,
            'last_name' => $formattedLast,
            'full_name' => "$formattedFirst $formattedLast"
        ];
    }
}

function generate_birth_date()
{
    $year = rand(2000, 2005);
    $month = str_pad(rand(1, 12), 2, '0', STR_PAD_LEFT);
    $day = str_pad(rand(1, 28), 2, '0', STR_PAD_LEFT);
    return "$year-$month-$day";
}

function generate_psu_email($firstName, $lastName)
{
    $digitCount = rand(0, 1) ? 3 : 4;
    $digits = '';
    for ($i = 0; $i < $digitCount; $i++) {
        $digits .= rand(0, 9);
    }
    return strtolower($firstName) . '.' . strtolower($lastName) . $digits . '@psu.edu';
}
